/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.machine.precipitator;

import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.gui.client.machine.GuiPrecipitator;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.machine.BaseRecipeCategory;
import cofh.thermalexpansion.plugins.jei.machine.precipitator.PrecipitatorRecipeWrapper;
import cofh.thermalexpansion.util.managers.machine.PrecipitatorManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class PrecipitatorRecipeCategory
extends BaseRecipeCategory<PrecipitatorRecipeWrapper> {
    public static boolean enable = true;
    protected IDrawableStatic progress;
    protected IDrawableStatic speed;
    protected IDrawableStatic slot;
    protected IDrawableStatic tankOverlay;

    public static void register(IRecipeCategoryRegistration registry) {
        String category = "Plugins.JEI";
        if (!(enable = ThermalExpansion.CONFIG_CLIENT.get(category, "Machine.Precipitator", enable))) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new PrecipitatorRecipeCategory(guiHelper)});
    }

    public static void initialize(IModRegistry registry) {
        if (!enable) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipes(PrecipitatorRecipeCategory.getRecipes(guiHelper), "thermalexpansion.precipitator");
        registry.addRecipeClickArea(GuiPrecipitator.class, 85, 26, 24, 16, new String[]{"thermalexpansion.precipitator"});
        registry.addRecipeCatalyst((Object)BlockMachine.machinePrecipitator, new String[]{"thermalexpansion.precipitator"});
    }

    public static List<PrecipitatorRecipeWrapper> getRecipes(IGuiHelper guiHelper) {
        ArrayList<PrecipitatorRecipeWrapper> recipes = new ArrayList<PrecipitatorRecipeWrapper>();
        for (PrecipitatorManager.PrecipitatorRecipe recipe : PrecipitatorManager.getRecipeList()) {
            recipes.add(new PrecipitatorRecipeWrapper(guiHelper, recipe));
        }
        return recipes;
    }

    public PrecipitatorRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(GuiPrecipitator.TEXTURE, 26, 11, 52, 40, 0, 22, 16, 96);
        this.energyMeter = Drawables.getDrawables(guiHelper).getEnergyEmpty();
        this.localizedName = StringHelper.localize((String)"tile.thermalexpansion.machine.precipitator.name");
        this.progress = Drawables.getDrawables(guiHelper).getProgress(2);
        this.speed = Drawables.getDrawables(guiHelper).getScale(10);
        this.slot = Drawables.getDrawables(guiHelper).getSlot(1);
        this.tankOverlay = Drawables.getDrawables(guiHelper).getTankSmallOverlay(2);
    }

    @Nonnull
    public String getUid() {
        return "thermalexpansion.precipitator";
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.progress.draw(minecraft, 69, 23);
        this.speed.draw(minecraft, 34, 40);
        this.slot.draw(minecraft, 101, 19);
        this.energyMeter.draw(minecraft, 2, 8);
    }

    public void setRecipe(IRecipeLayout recipeLayout, PrecipitatorRecipeWrapper recipeWrapper, IIngredients ingredients) {
        List inputFluids = ingredients.getInputs(FluidStack.class);
        List outputItems = ingredients.getOutputs(ItemStack.class);
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        guiItemStacks.init(0, false, 105, 23);
        guiFluidStacks.init(0, true, 34, 8, 16, 30, 8000, false, (IDrawable)this.tankOverlay);
        guiItemStacks.set(0, (List)outputItems.get(0));
        guiFluidStacks.set(0, (List)inputFluids.get(0));
    }
}

